# 帳票設計書 15-Usage Trends Report

## 概要

本ドキュメントは、GitLabにおけるUsage Trends Report機能の帳票設計書である。インスタンスの利用傾向レポートを画面表示する機能について、表示内容、データ構造、処理フローを定義する。

### 本帳票の処理概要

Usage Trends Reportは、GitLabインスタンス全体の利用状況を時系列で可視化するダッシュボード画面である。ユーザー数、プロジェクト数、グループ数、Issue数、Merge Request数などの主要指標の推移をグラフ形式で表示する。

**業務上の目的・背景**：インスタンスの成長傾向と利用パターンを把握し、リソース計画やキャパシティプランニングに活用する。ユーザー数やプロジェクト数の増加傾向を追跡することで、インフラストラクチャの拡張計画、ライセンス管理、利用促進施策の効果測定などに役立てることができる。

**帳票の利用シーン**：管理者がインスタンス全体の成長傾向を確認する場合、経営層へのインスタンス利用状況報告を作成する場合、キャパシティプランニングのための基礎データを収集する場合、利用促進施策の効果を測定する場合などで利用される。

**主要な出力内容**：
1. ユーザー数の推移グラフ
2. プロジェクト数の推移グラフ
3. グループ数の推移グラフ
4. Issue数の推移グラフ
5. Merge Request数の推移グラフ
6. パイプライン数の推移グラフ
7. その他のインスタンス統計

**帳票の出力タイミング**：管理者画面のUsage Trendsページにアクセスした際に表示される。データはGraphQL APIを通じて取得される。

**帳票の利用者**：システム管理者、インフラストラクチャ担当者、経営層

## 帳票種別

画面表示（トレンドグラフダッシュボード）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Usage Trends | `/admin/usage_trends` | 画面アクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（画面表示） + Vue.jsコンポーネント |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 画面表示 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

画面構成（トレンドダッシュボード）

```
┌─────────────────────────────────────────────────────────────┐
│                    Usage Trends                             │
├─────────────────────────────────────────────────────────────┤
│  ┌─────────────────────┐  ┌─────────────────────┐          │
│  │    Users Trend      │  │   Projects Trend    │          │
│  │    [グラフ]         │  │    [グラフ]         │          │
│  └─────────────────────┘  └─────────────────────┘          │
│  ┌─────────────────────┐  ┌─────────────────────┐          │
│  │    Groups Trend     │  │    Issues Trend     │          │
│  │    [グラフ]         │  │    [グラフ]         │          │
│  └─────────────────────┘  └─────────────────────┘          │
│  ┌─────────────────────┐  ┌─────────────────────┐          │
│  │     MRs Trend       │  │   Pipelines Trend   │          │
│  │    [グラフ]         │  │    [グラフ]         │          │
│  └─────────────────────┘  └─────────────────────┘          │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | レポートタイトル | "Usage Trends" | 固定値 | 文字列 |

### 明細部（トレンドグラフ）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Users | ユーザー数の推移 | analytics_usage_trends_measurements | 折れ線グラフ |
| 2 | Projects | プロジェクト数の推移 | analytics_usage_trends_measurements | 折れ線グラフ |
| 3 | Groups | グループ数の推移 | analytics_usage_trends_measurements | 折れ線グラフ |
| 4 | Issues | Issue数の推移 | analytics_usage_trends_measurements | 折れ線グラフ |
| 5 | Merge Requests | MR数の推移 | analytics_usage_trends_measurements | 折れ線グラフ |
| 6 | Pipelines | パイプライン数の推移 | analytics_usage_trends_measurements | 折れ線グラフ |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 管理者権限 | 管理者画面へのアクセス権限 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | recorded_at | 昇順（時系列） |

### 改ページ条件

N/A（単一画面）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| analytics_usage_trends_measurements | 利用トレンドデータ | 主テーブル |

### テーブル別参照項目詳細

#### analytics_usage_trends_measurements

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| identifier | メトリクス種別 | - | ユーザー/プロジェクト等の区別 |
| count | 数値 | - | その時点の総数 |
| recorded_at | 記録日時 | - | x軸の値 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | - | - | 計算項目なし（生データを表示） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[画面アクセス] --> B[管理者権限チェック]
    B -->|権限あり| C[Vue.jsコンポーネント初期化]
    B -->|権限なし| Z[アクセス拒否]
    C --> D[GraphQL APIリクエスト]
    D --> E[analytics_usage_trends_measurementsクエリ]
    E --> F[データ取得]
    F --> G[グラフ描画]
    G --> H[画面表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 測定データが存在しない | 空のグラフ表示 | データ収集ジョブの実行を確認 |
| 権限エラー | 管理者権限がない | Access denied | 管理者権限を取得する |
| GraphQLエラー | APIエラー | エラーメッセージ表示 | 再読み込みを試行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 期間に応じた測定データ（日次） |
| 目標出力時間 | 2秒以内 |
| 同時アクセス数上限 | 特になし |

## セキュリティ考慮事項

- 管理者画面のため、管理者権限を持つユーザーのみアクセス可能
- 集計データのみ表示し、個別データは含まれない
- 内部イベントトラッキング（i_analytics_instance_statistics）で利用状況を記録

## 備考

- データ表示はVue.jsコンポーネントで実装
- GraphQL APIを使用してデータを取得
- グラフ描画にはGitLab UIのチャートコンポーネントを使用

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Usage Trendsのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | analytics_usage_trends_measurement.rb | `app/models/analytics/usage_trends/measurement.rb` | 測定データモデル。identifier、count、recorded_atが主要属性 |

**読解のコツ**: identifierで測定種別（users、projects等）を区別。countはその時点の累計値。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | usage_trends_controller.rb | `app/controllers/admin/usage_trends_controller.rb` | コントローラ。indexアクションは空（フロントエンド主導） |

**主要処理フロー**:
1. **6-10行目**: track_event - 利用状況のトラッキング
2. **12行目**: feature_category :devops_reports
3. **16行目**: indexアクション - 空実装（Vue.jsに委譲）

#### Step 3: フロントエンド層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | usage_trends_app.vue | `app/assets/javascripts/analytics/usage_trends/components/usage_trends_app.vue` | メインVueコンポーネント |
| 3-2 | usage_trends_count_chart.vue | `app/assets/javascripts/analytics/usage_trends/components/usage_trends_count_chart.vue` | グラフコンポーネント |

**主要処理フロー**:
- GraphQL APIを呼び出してデータ取得
- GitLab UIのチャートコンポーネントでグラフ描画

### プログラム呼び出し階層図

```
Admin::UsageTrendsController#index
    │
    └─ index.html.haml (空のテンプレート)
           │
           └─ Vue.js Application 初期化
                  │
                  └─ UsageTrendsApp.vue
                         │
                         ├─ GraphQL Query (usageTrendsMeasurements)
                         │      └─ analytics_usage_trends_measurements テーブル
                         │
                         └─ UsageTrendsCountChart.vue (×複数)
                                ├─ Users Trend
                                ├─ Projects Trend
                                ├─ Groups Trend
                                ├─ Issues Trend
                                ├─ Merge Requests Trend
                                └─ Pipelines Trend
```

### データフロー図

```
[入力]                      [処理]                         [出力]

analytics_usage_trends_   ─▶ GraphQL API ────────────▶ Vue.js App
measurements テーブル         (usageTrendsMeasurements)      │
                                                             └─▶ UsageTrendsCountChart
                                                                  (×メトリクス種別)
                                                                       │
                                                                       ├─ identifier
                                                                       ├─ count (y軸)
                                                                       └─ recorded_at (x軸)
                                                                             ↓
                                                                       グラフ描画
                                                                             ↓
                                                                        画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| usage_trends_controller.rb | `app/controllers/admin/usage_trends_controller.rb` | ソース | コントローラ |
| measurement.rb | `app/models/analytics/usage_trends/measurement.rb` | ソース | 測定データモデル |
| usage_trends_app.vue | `app/assets/javascripts/analytics/usage_trends/components/usage_trends_app.vue` | ソース | メインVueコンポーネント |
| usage_trends_count_chart.vue | `app/assets/javascripts/analytics/usage_trends/components/usage_trends_count_chart.vue` | ソース | グラフコンポーネント |
| usage_trends.query.graphql | `app/graphql/queries/analytics/usage_trends.query.graphql` | ソース | GraphQLクエリ |
| index.html.haml | `app/views/admin/usage_trends/index.html.haml` | テンプレート | 画面テンプレート |
